#include<iostream>
#include<iomanip>
#include<vector>
#include<string>
#include<algorithm>
#include<set>
#include<unordered_set>
#include<map>
#include<unordered_map>
#include<deque>
#include<queue>
#include<stack>
#include<random>
#include<ios>
#include<cmath>
#include<cctype>
#include<fstream>
#include<ctime>
#include<time.h>

using namespace std;

typedef long long ll;

struct Point {
	ll x, y;
	Point() {}
	Point(ll x, ll y) : x(x), y(y) {}
};

int sz(ll a) {
	if (a > 0) return 1;
	if (a < 0) return -1;
	return 0;
}

Point operator -(const Point& a, const Point& b) {
	return Point(a.x - b.x, a.y - b.y);
}

bool operator ==(const Point& a, const Point& b) {
	return a.x == b.x && a.y == b.y;
}


ll cP(const Point& a, const Point& b) {
	return a.x * b.y - a.y * b.x;
}

ll dP(const Point& a, const Point& b) {
	return a.x * b.x + a.y * b.y;
}


bool fff(int a, int b, int c, int d) {
	if (a > b) swap(a, b);
	if (c > d) swap(c, d);
	return min(b, d) >= max(a, c);
}


bool isSegmentsCross(pair<Point, Point>& p1, pair<Point, Point>& p2) {
	Point a = p1.first, b = p1.second;
	Point c = p2.first, d = p2.second;
	bool tmp = sz(cP(d - c, a - c)) * sz(cP(d - c, b - c)) <= 0 && sz(cP(a - b, c - b)) * sz(cP(a - b, d - b)) <= 0 
		&& fff(a.x, b.x, c.x, d.x) && fff(a.y, b.y, c.y, d.y);
	return tmp;
}

int main() {
	ios::sync_with_stdio(0);
	cin.tie(0);
	int t;
	cin >> t;
	for (int test = 0; test < t; ++test) {
		int n;
		cin >> n;
		vector<vector<pair<Point, Point>>> s;
		ll ans = 0;
		for (int k = 0; k < n; ++k) {

			Point a, b;
			cin >> a.x >> a.y >> b.x >> b.y;
			pair<Point, Point> curpair = { a, b };
			vector<int> per(s.size());
			for (int i = 0; i < s.size(); ++i) {
				int cnt = 0;
				for (auto p : s[i]) {
					if (isSegmentsCross(curpair, p)) ++cnt;
				}
				per[i] = cnt;
			}
			s.push_back(vector<pair<Point, Point>>());
			for (int i = 0; i < s.size() - 1; ++i) {
				ans += max(0, per[i] - 1);
				if (per[i] >= 1) {
					for (auto now : s[i]) s.back().push_back(now);
					s[i].clear();
				}
			}
			s.back().push_back(curpair);
		}
		cout << ans + 1 << '\n';

	}
}
/*
1
7
1 0 3 0
3 0 2 1
2 1 1 0
-1 0 -3 0
-3 0 -2 -1
-2 -1 -1 0
-14 1 14 0
*/